/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/* * 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 8, 2003
 * Title : Validators.AddressValidator.java
 * Desprition : This Validators class is responsible for checking and validating the 
 * Customer Address Information
 * 
 */
package Validators;

import JavaBeans.*;
/**
 * @author student
 *
 * This class is being used forvalidation of address data.
 * 
 */
public class AddressValidator {
	private String message;

	/**
	 * This method is being used for getting the error message if 
	 * validation is unsuccessful.
	 * @return String The message to be displayed.
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * This method is being used for setting an error message if the
	 * validation is unsuccessful. 
	 * @param message The message to be displayed. 
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * This method is being used for validating the given address data.
	 * @param addressData The address details that are to be validated.
	 * @return boolean Specifies whether the validation was successful.
	 */
	public boolean validate(Address_Data addressData) {

		Address_Data addressdata = addressData;
		String email, street, city, floor, building, office, phoneNumber;

		email = addressdata.getEmail();
		street = addressdata.getStreet();
		city = addressdata.getCity();
		floor = addressdata.getFloor();
		building = addressdata.getBuilding();
		office = addressdata.getOffice();
		phoneNumber = addressdata.getPhoneNumber();

		//if any fields are not specified, validation is unsuccessful.
		if (street == null
			|| city == null
			|| floor == null
			|| building == null
			|| office == null) {
			message = "Some of the required address fields are empty.";
			return false;
		}
		if (phoneNumber == null) {
			message = "Phone number field is empty.";
			return false;
		}
		//check email address.
		if (!isValidEmailAddress(email)) {
			return false;
		}
		//check street.
		if (!street.matches("^[a-zA-Z/(/)0-9/ ///,/./-]+$")) {
			message = "Street has invalid characters.";
			return false;
		}
		//check city.
		if (!city.matches("^[a-zA-Z/(/)0-9/ ///,/./-]{1,50}+$")) {
			message = "City has invalid characters.";
			return false;
		}
		//check building.
		if (!building.matches("^[a-zA-Z/(/)0-9/ ///,/./-]+$")) {
			message = "Building has invalid characters.";
			return false;
		}
		//check floor.
		if (!floor.matches("^[a-zA-Z/(/)0-9/s/ ///,/./-]+$")) {
			message = "Floor has invalid characters.";
			return false;
		}
		//check office.
		if (!office.matches("^[a-zA-Z/(/)0-9/s/ ///,/./-]+$")) {
			message = "Office has invalid characters.";
			return false;
		}
		//check phone number.
		if (!phoneNumber.matches("^[/(/)0-9/s/ ///./-]{7,12}+$")) {
			message = "Phone number has invalid characters.";
			message += " Phone number must be between 7 and 12 digits long";
			return false;
		}

		return true;
	}


	/**
	 * This method is being used for validating email addresses.
	 * @param strEmailAddress The email address to be checked.
	 * @return boolean Specifies whether the validation was successful.
	 */
	private boolean isValidEmailAddress(String strEmailAddress) {

		boolean bValid = true;

		// return false if strEmailAddress is either null or empty
		if (isNullorEmpty(strEmailAddress)) {
			setMessage("Email address is empty.");
			return false;
		}

		// calculate length of the email address
		int iLength = strEmailAddress.length();

		// get the first occurrence of @ char
		int iCharAtPosition = strEmailAddress.indexOf("@");

		// validation fails if @ character is not present 
		if (iCharAtPosition == -1) {
			setMessage("@ character is not found in Email address.");
			bValid = false;
		}
		// validation fails if @ character found is in the first or last position
		else if (
			(iCharAtPosition == 0) || (iCharAtPosition == (iLength - 1))) {
			setMessage("@ character is not allowed to be in the first or last position in Email address.");
			bValid = false;
		}
		// validation fails if more than 1 @ character are present 
		else if (strEmailAddress.indexOf("@", iCharAtPosition + 1) > -1) {
			setMessage("More than 1 @ characters are not allowed in Email address.");
			bValid = false;
		} else {

			// traverse thru all the characters in the given email address
			for (int i = 0; i < iLength; i++) {

				// get the character at the i position
				char c = strEmailAddress.charAt(i);

				if (c == '.') {
					// validation fails if . character found is in the first or last position
					if ((i == 0) || (i == (iLength - 1))) {
						setMessage(". character is not allowed in the first or the last postion in Email address.");
						bValid = false;
						break;
					}
					// . character cannot come before @ character
					else if (i == (iCharAtPosition - 1)) {
						setMessage(". character cannot immediately precede @ character in Email address.");
						bValid = false;
						break;
					}
				}
				// all these are invalid characters
				else if (
					c > '~'
						|| c < '!'
						|| c == '('
						|| c == ')'
						|| c == '<'
						|| c == '>'
						|| c == '['
						|| c == ']'
						|| c == ','
						|| c == ';'
						|| c == ':'
						|| c == '\\'
						|| c == '"') {
					setMessage(
						"Invalid character " + c + " found in Email address.");
					bValid = false;
					break;
				}
			}
		}
		// return the validation flag 
		return bValid;
	}
	
	/**
	 * This utility method is being used for checking if a given string is null
	 * or empty.
	 * @param s The string to be checked.
	 * @return boolean Specifies whether the validation was successful.
	 */
	private static boolean isNullorEmpty(String s) {
		if (s == null || s.length() == 0) {
			return true;
		}
		return false;
	}
}